#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include "base.h"

/*
 * @Function:		calc_diff_time
 * @Input
 * 		start:		starting timestamp
 * 		stop:		stopped timestamp
 * @Return:			time difference from start to stop, in nanoseconds
 *
 * */
float calc_diff_time(struct timespec *start, struct timespec *stop)
{
	float diff_time;

	diff_time = (float)(stop->tv_sec-start->tv_sec)*1000*1000*1000
					+ (float)(stop->tv_nsec-start->tv_nsec);

	return diff_time;
}

int file_exists(char *filename)
{
	return (access(filename, 0) == 0);
}

void check_current_env()
{
	/* Detect at Android device or at PC */
#ifdef ANDROID
	debug_print("INFO", "Running on Android phone!\n");
#else
	debug_print("INFO", "Running on PC!\n");
#endif
}
